###### Tipo de Origem ###########

# Atencao: Este script foi salvo criado com codificacao UTF-8.

# Essa funo tem apenas o argumentos "grupo". 
# grupo = (geral, grupo1, grupo2, grupo3)


# Pacotes usados
library(data.table)
library(dplyr)
library(tidyr)
library(ggplot2)
library(scales)
library(forcats) #para a funo fct_reorder()

#  L sisdof_tora
sisdof_tora <- fread("SisDOF-toras_2012_2017.csv",
                     colClasses = c("character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "numeric", "numeric"))

# Deleta coluna V1 criada pelo comando fread.
sisdof_tora$V1 <- NULL

#### Formatacao dos dados ####

# Elimina as observaes que tenham Tipo.de.Origem == "RCEE" == Reflorestamento com especies exoticas
sisdof_tora <- sisdof_tora[sisdof_tora$Tipo.de.Origem != "RCEE"]

# Troca espaos por "."
sisdof_tora$Tipo.de.Origem <- gsub("\\.", " ", sisdof_tora$Tipo.de.Origem)

#### Funcao para gerar graficos ####
tipo_origem <- function (grupo) {
    
    # grupo = (geral, grupo1, grupo2, grupo3)
    
    # geral = todas as espcies 
    # grupo1 = especies de grande movimentacao
    # grupo2 = ameacadas (Portaria 443)
    # grupo3 = cites
    
    # Funo para passar apenas a primeira letra de uma palavra para maiscula
    capFirst <- function(s) {
        paste(toupper(substring(s, 1, 1)), substring(s, 2), sep = "")
    }
    
    # Ttulos do grfico
    titulo.grupo <- capFirst(grupo)
    g.titulo <- "Formas de Produo Madeireira\n"   # Primeiro titulo do grafico
    g.sub.titulo <- "Volume relativo produzido de 2012 a 2017 (%)\n"
    
    # Dimensoes do grafico
    #largura <- 10.3
    texto <- 21.87
    bola <- 25.5
    
    # Cores do Grafico: Tons azuis 
    cor_segmento <- "lightskyblue"                # cor da linha   
    cor_ponto <- "navy"                   # cor do ponto
    
    # Muda diretrio de trabalho para o de Toras. Cria o diretorio se ja nao existir.
    
    ifelse(!dir.exists(file.path("Figuras", 
                                 "1.1.Toras", 
                                 "1.1.7.Tipo.Origem")),
           dir.create(file.path("Figuras", 
                                "1.1.Toras", 
                                "1.1.7.Tipo.Origem"),
                      recursive = TRUE),
           FALSE)
    
    setwd(file.path("Figuras", 
                    "1.1.Toras", 
                    "1.1.7.Tipo.Origem"))
    
    if ( grupo == "geral") {
        
        y <- sisdof_tora
        g.sub.titulo.grupo <- "Todas as espcies"
        
    } else if (grupo == "grupo1") {
        
        lista_especies <- unique(sisdof_tora[sisdof_tora$Grupo == "Grupo.1"]$Especie)   # lista os nomes das espcies contidas no grupo 1
        y <- sisdof_tora[sisdof_tora$Grupo == "Grupo.1"]                            # subset com as espcies do grupo 1
        g.sub.titulo.grupo <- "25 Espcies mais movimentadas"
        
    } else if (grupo == "grupo2") {
        
        lista_especies <- unique(sisdof_tora[sisdof_tora$Grupo == "Grupo.2"]$Especie)   # lista os nomes das espcies contidas no grupo 2
        y <- sisdof_tora[!is.na(sisdof_tora$Portaria.443)]                        # subset com as espcies da portaria 443 e que nao estao nos grupos 1 ou 3
        g.sub.titulo.grupo <- "Espcies ameaadas de extino"
                         
    } else if (grupo == "grupo3") {
        
        lista_especies <- unique(sisdof_tora[sisdof_tora$Grupo == "Grupo.3"]$Especie)   # lista os nomes das espcies contidas no grupo 3
        y <- sisdof_tora[!is.na(sisdof_tora$Cites)]                                # subset com as espcies da portaria 443 e que nao estao nos grupos 1 ou 3
        g.sub.titulo.grupo <- "Espcies CITES"
                         
    }
    
    ## Faz o grfico dos grupos
    
    ## Faz o grfico dos grupos
    
    # Agrega de acordo com o Tipo.de.Origem
    agregado <- y[, .(sum(Volume.Total)),
                  by = .(y$Tipo.de.Origem)]
    
    # Cria a coluna volume percentual
    agregado$Volume.Percentual <- agregado$V1/sum(agregado$V1)*100
    
    # Renomeia as colunas V1 e V2  
    colnames(agregado) <- c("Tipo.de.Origem", "Volume.Total", "Volume.Percentual")
    
    # Para o grafico entender que  pra ordenar pelo Volume.Total
    agregado$Tipo.de.Origem <- factor(agregado$Tipo.de.Origem, 
                               levels = unique(agregado$Tipo.de.Origem)[order(agregado$Volume.Percentual, 
                                                                       decreasing = TRUE)])
    
    # Ordena de forma crescente em relao ao Volume.Total
    agregado <- agregado[order(agregado$Volume.Percentual, decreasing = TRUE),]
    
    # Seleciona no mximo 10 Tipos de Origens
    
    if (length(unique(agregado$Tipo.de.Origem)) >= 10) {
        
        agregado <- agregado[1:10,]
        
        }   else {
        
        agregado <- agregado[1:length(unique(agregado$Tipo.de.Origem)),]
        
        }  
    
    # Largura do grafico. Varia de acordo com o tamanho do titulo ou subtitulo. Como a fonte do titulo e 10% maior do que a do subtitulo, multiplicamos por 1.11.
    
    largura <- data.table(tipo = c("g.titulo", "lista.especie", "g.sub.titulo"),
                          valor = c(1.11*nchar(g.titulo), 
                                    nchar(g.sub.titulo.grupo),
                                    nchar(g.sub.titulo)))
    
    largura <- max(largura$valor, na.rm = TRUE)
    
    # Altura do grafico. Varia conforme o mnumero de tipos de origem.
    altura <- 1.8 + (1.15*length(agregado$Tipo.de.Origem))
    
    if (length(agregado$Tipo.de.Origem) != 0) {
        
        # Para ordenar as barras de forma decrescente quando o grafico fica deitado.
        agregado <- mutate(agregado,  Tipo.de.Origem = fct_reorder(agregado$Tipo.de.Origem,
                                                            agregado$Volume.Percentual))
    
    # Gera o grafico percentual
    
    gplot <- ggplot(agregado, aes(agregado$Tipo.de.Origem,
                                  agregado$Volume.Percentual)) +
        geom_segment(aes(x = agregado$Tipo.de.Origem, 
                         y = 0, 
                         xend = agregado$Tipo.de.Origem, 
                         yend = agregado$Volume.Percentual),
                     position = position_dodge(width = 0.8),
                     color = cor_segmento,
                     size = bola/3) +
        geom_point(size = bola,
                   color = cor_ponto,
                   position = position_dodge(width = 0.8))+
        geom_text(aes(y = 0, label = agregado$Tipo.de.Origem),             # Formata os valores de y. Arredonda para duas casas decimais. Coloca "." como separador de milhar e "," como separador decimal
                  hjust = 0,
                  vjust = -1.75,
                  size = 0.4*texto,
                  color = cor_ponto,
                  fontface = "bold") + 
        geom_text(aes(label = format(round(Volume.Percentual, 2),     # texto do Volume.Percentual
                                     big.mark = ".", 
                                     decimal.mark = ",")),
                  color = "white", 
                  size = 0.3*texto,
                  fontface = "bold")+
        labs(title = g.titulo,
             subtitle = paste0(g.sub.titulo.grupo,
                               "\n\n",
                               g.sub.titulo,
                               "\n"))+
        theme(plot.title = element_text(lineheight = 0.1, 
                                        face = "bold",
                                        hjust = 0.5,
                                        size = 1.3*texto),
              plot.subtitle = element_text(lineheight = 0.4, 
                                           face = "bold",
                                           hjust = 0.5,
                                           size = 1.17*texto),
              axis.title.y = element_blank(),
              axis.text.y = element_blank(),
              axis.title.x = element_blank(),
              axis.text.x = element_blank(),
              axis.ticks.x = element_blank(),
              axis.ticks.y = element_blank(),
              panel.background = element_blank(),
              panel.grid.major = element_blank(), 
              panel.grid.minor = element_blank())+
        coord_flip()
    
    # Abre para gravacao em PDF
    pdf(paste0("#", 
               titulo.grupo,
               "_Origem.pdf"),
        width = largura/4.5, 
        height = altura)
    
    print(gplot)
    
    # Fecha o PDF
    dev.off()
    
    }
    
    ## Faz os grficos para cada uma das espcies da lista dos grupos 1, 2 ou 3.
    
    if (grupo == "grupo1" | grupo == "grupo2" | grupo == "grupo3") {
        
        for (i in 1:length(lista_especies)) {
            especie <- y[y$Especie == lista_especies[i]]
            
            # Agrega de acordo com os tipos de Tipo.de.Origems
            especie <- especie[, .(sum(Volume.Total)),
                               by = .(especie$Tipo.de.Origem)]
            
            colnames(especie) <- c("Tipo.de.Origem", "Volume.Total")
            
            # Cria a coluna volume percentual
            especie$Volume.Percentual <- especie$Volume.Total/sum(especie$Volume.Total)*100
            
            # Para o grafico entender que  pra ordenar pelo Volume.Total
            especie$Tipo.de.Origem <- factor(especie$Tipo.de.Origem, 
                                      levels = unique(especie$Tipo.de.Origem)[order(especie$Volume.Percentual, 
                                                                             decreasing = TRUE)])
            
            
            # Ordena de forma crescente em relao ao Volume.Total
            especie <- especie[order(especie$Volume.Percentual, decreasing = TRUE),]
            
            # Seleciona no mximo 20 paises
            
            if (length(unique(especie$Tipo.de.Origem)) >= 10) {
                
                especie <- especie[1:10,]
                
               }    else {
                
                especie <- especie[1:length(unique(especie$Tipo.de.Origem)),]
                
               }
            
            # Largura do grafico.
            largura <- data.table(tipo = c("g.titulo", "lista.especie", "g.sub.titulo"),
                                  valor = c(1.11*nchar(g.titulo), 
                                            nchar(lista_especies[i]),
                                            nchar(g.sub.titulo)))
            largura <- max(largura$valor, na.rm = TRUE)
            
            # Altura do grafico
            altura <- 1.8 + (1.15*length(especie$Tipo.de.Origem))
            
            if (length(especie$Tipo.de.Origem) != 0) {
                
                # Para ordenar as barras de forma decrescente quando o grafico fica deitado.
                especie <- mutate(especie,  Tipo.de.Origem = fct_reorder(especie$Tipo.de.Origem,
                                                                  especie$Volume.Percentual))
                
            
            gplot <- ggplot(especie, 
                            aes(especie$Tipo.de.Origem,
                                especie$Volume.Percentual))+
                geom_segment(aes(x = especie$Tipo.de.Origem, 
                                 y = 0, 
                                 xend = especie$Tipo.de.Origem, 
                                 yend = especie$Volume.Percentual),
                             position = position_dodge(width = 0.8),
                             color = cor_segmento,
                             size = bola/3) +
                geom_point(size = bola,
                           color = cor_ponto,
                           position = position_dodge(width = 0.8))+
                geom_text(aes(y = 0, label = especie$Tipo.de.Origem),             # Formata os valores de y. Arredonda para duas casas decimais. Coloca "." como separador de milhar e "," como separador decimal
                          hjust = 0,
                          vjust = -1.75,
                          size = 0.4*texto,
                          color = cor_ponto,
                          fontface = "bold") + 
                geom_text(aes(label = format(round(Volume.Percentual, 2),     # texto do Volume.Percentual
                                             big.mark = ".", 
                                             decimal.mark = ",")),
                          color = "white", 
                          size = 0.3*texto,
                          fontface = "bold")+
                labs(title = g.titulo,
                     subtitle = paste0(lista_especies[i],
                                       "\n\n",
                                       g.sub.titulo,
                                       "\n"))+
                theme(plot.title = element_text(lineheight = 0.1, 
                                                face = "bold",
                                                hjust = 0.5,
                                                size = 1.3*texto),
                      plot.subtitle = element_text(lineheight = 0.4, 
                                                   face = "bold",
                                                   hjust = 0.5,
                                                   size = 1.17*texto),
                      axis.title.y = element_blank(),
                      axis.text.y = element_blank(),
                      axis.title.x = element_blank(),
                      axis.text.x = element_blank(),
                      axis.ticks.x = element_blank(),
                      axis.ticks.y = element_blank(),
                      panel.background = element_blank(),
                      panel.grid.major = element_blank(), 
                      panel.grid.minor = element_blank())+
                coord_flip()
            
            # Abre para gravacao em PDF
            pdf(paste0(titulo.grupo,"_", 
                       lista_especies[i],
                       "_Origem.pdf"), 
                width = largura/4.5,
                height = altura)
            print(gplot)
            
            # Fecha o PDF
            dev.off()
            
            }
            
        }
        
    }
    
    setwd("..")
    setwd("..")
    setwd("..")
    
}  

tipo_origem("geral")
tipo_origem("grupo1")
tipo_origem("grupo2")
tipo_origem("grupo3")

